
#IFDEF __STORY_DEBUG__
	Print _constEngine_ & " " & _constBuild_ & " / Page / Allocation / Options"
	SimpleWait ( )
#ENDIF

Declare Sub Options_Destroy ( Options As Story_Option_Type )

Declare Sub Multi_Options_Destroy ( Desc ( Any ) As Story_Option_Type )

Declare Sub Multi_Option_Load ( Options ( Any ) As Story_Option_Type, ByRef Buffer As String )

Declare Sub Option_Load ( Options As Story_Option_Type, ByRef Buffer As String )

Sub Options_Destroy ( Options As Story_Option_Type )

	With Options
	
		'If .Active > 0 Then
			
			.Key = ""
			.Dest = 0
			.Req = 0
			.Caption = ""
			
			.Active = 0
		
		'End If
	
	End With
	
End Sub

Sub Multi_Options_Destroy ( Options ( Any ) As Story_Option_Type )

	Dim As Long Index = 0

	If UBound( Options, 1 ) < 0 Then
		Erase Options
		ReDim Options ( -1 To -1 )
		Exit Sub
	End If

	For Index = 0 To Ubound ( Options, 1 ) Step 1

		Options_Destroy ( Options ( Index ) )
				
	Next Index
	
	Erase Options
	ReDim Options ( -1 To -1 )
	
End Sub

Sub Multi_Option_Load ( Options ( Any ) As Story_Option_Type, ByRef Buffer As String )
	
	Dim As Long Index = 0

	/' Options '/

	ReDim Options ( 1 To 4 )

	For Index = 0 To Ubound ( Options, 1 ) Step 1
	
		Option_Load ( Options ( Index ), Buffer )
		
	Next Index
	
End Sub

Sub Option_Load ( Options As Story_Option_Type, ByRef Buffer As String )

	Dim As String Dat
	Dat = ""

	/' Options '/
	
	With Options
	
		Dat = Prefix ( CRLF, Buffer )
		Buffer = Suffix ( CRLF, Buffer )

		.Key = Trim ( Trim ( Prefix ( ",", Dat ), QUOT ), SP )
			
		Dat = Suffix ( ",", Dat )

		.Dest = ValInt ( Trim ( Prefix ( ",", Dat ), SP ) )
			
		Dat = Suffix ( ",", Dat )
			
		.Req = ValInt ( Trim ( Prefix ( ",", Dat ), SP ) )
			
		Dat = Suffix ( ",", Dat )

		.Caption = Trim ( Trim ( Prefix ( ",", Dat ), QUOT ), SP )
			
		.Active = 1

	End With

End Sub
